<?php

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Menu_Controller
{
  public function __construct()
  {
    add_action('wp_ajax_ultimate_ai_create_menu', [$this, 'ultimate_ai_create_menu']);
    add_action('wp_ajax_ultimate_ai_get_menu', [$this, 'ultimate_ai_get_menu']);
  }


  public function ultimate_ai_get_menu()
  {
    $menu = get_option('ultimate_ai_menu_data', []);

    wp_send_json($menu, 200);
  }


  public function ultimate_ai_create_menu()
  {

    restrict_req_for_admin();

    $menu = isset($_POST['menu']) ? $_POST['menu'] : [];

    if (!$this->option_exists("ultimate_ai_menu_data")) {
      add_option("ultimate_ai_menu_data", $menu);
    } else {
      update_option('ultimate_ai_menu_data', $menu);
    }

    $menu = get_option('ultimate_ai_menu_data', []);

    wp_send_json($menu, 200);
  }


  public function option_exists($name, $site_wide = false)
  {
    global $wpdb;
    return $wpdb->query("SELECT * FROM " . ($site_wide ? $wpdb->base_prefix : $wpdb->prefix) . "options WHERE option_name ='$name' LIMIT 1");
  }
}

new Ultimate_AI_Menu_Controller();
